package cn.com.duiba.zhongyan.activity.service.api.enums;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author xuanyu
 * @description: 中奖状态枚举
 * @date 2021/11/25 5:47 下午
 */
@Getter
@AllArgsConstructor
public enum PrizeStatusEnum {
    UNCONFIRMED(0,"未确认"),
    NOT_CLAIMED(1,"未领取"),
    CLAIMED(2,"已领取"),
    DELETED(3,"已删除"),
    BACK_TO_ACTIVITY(4,"回退到活动库存"),
    BACK_TO_ITEMS(4,"回退到商品库存")
    ;

    /**
     * 奖品状态
     */
    private Integer prizeStatus;

    /**
     * 奖品描述
     */
    private String desc;

    /**
     * 根据状态获取描述
     * @param status 奖品状态
     * @return 描述
     */
    public static String getDescByStatus(Byte status){
        List<PrizeStatusEnum> prizeStatusEnumsList = Lists.newArrayList(UNCONFIRMED, NOT_CLAIMED, CLAIMED);
        PrizeStatusEnum prizeStatusEnum = prizeStatusEnumsList.stream().filter(p -> p.getPrizeStatus().equals(status.intValue())).findFirst().orElse(null);
        if(Objects.isNull(prizeStatusEnum)){
            return "";
        }
        return prizeStatusEnum.getDesc();
    }

}
