package cn.com.duiba.zhongyan.activity.service.api.param;

import cn.com.duiba.zhongyan.activity.service.api.base.BasePageParam;
import cn.com.duiba.zhongyan.activity.service.api.enums.PrizeStatusEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xuanyu
 * @description:
 * @date 2021/11/27 5:59 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UserPrizeRecordPageQueryParam extends BasePageParam implements Serializable {
    private static final long serialVersionUID = -7874724706586646401L;
    /**
     * id
     */
    private Long id;

    /**
     * 奖品id，传了这个查询满足list内id的奖品
     */
    private List<Long> prizeIdList;

    /**
     * 用户id列表
     */
    private List<Long> userIdList;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 奖品id
     */
    private Long prizeId;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * openId
     */
    private String openId;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 用户昵称
     */
    private String nick;

    /**
     * 奖品名
     */
    private String prizeName;

    /**
     * @see PrizeStatusEnum
     * 中奖状态(查询参数in里用)
     */
    private List<Byte> prizeStatusList;

    /**
     * 领取时间等于 秒级时间戳
     */
    private Long receiveTime;

    /**
     * 领取时间起始(范围查询)
     */
    private Long receiveStartTime;

    /**
     * 领取时间结束(范围查询)
     */
    private Long receiveEndTime;

    /**
     * 确认时间 秒级时间戳
     */
    private Long confirmTime;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;
}
