package cn.com.duiba.zhongyan.activity.service.api.domain.dto;


import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by hong
 * time 2022/7/7.
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class ActivitySnapshotDto implements Serializable {
    private static final long serialVersionUID = 8391102356774544450L;
    /**
     * id
     */
    private Long id;

    /**
     * 0未删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 基本配置
     */
    private String configJson;

    /**
     * 活动标题
     */
    private String activityTitle;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 操作人
     */
    private Long createBy;

    /**
     * 玩法配置
     */
    private String playConfig;

    /**
     * 界面配置
     */
    private String faceConfig;

    /**
     * 是否是复制的活动
     * 1-复制活动  0/null-非复制活动
     */
    private Integer copy;
    /**
     * 1-预览并保存  0/null-发布
     */
    private Integer preview;

    /**
     * 操作人名称
     */
    private String createByName ;



}
