package cn.com.duiba.zhongyan.activity.service.api.domain.dto;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by hong
 * time 2022/3/23.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryAllActivityDTO extends PageRequest implements Serializable {

    private static final long serialVersionUID = -3743042047184726706L;
    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动类型
     */
    private String type;

    /**
     * 是否中奖 0:未中奖 1:已中奖
     */
    private Integer acquirePrize;

    /**
     * 开始时间 秒级时间戳
     */
    private Date startTime;

    /**
     * 结束时间 秒级时间戳
     */
    private Date endTime;


    /**
     * 开始时间筛选开始节点  秒级时间戳
     */
    private Date startTimeStartNode;

    /**
     * 开始时间筛选结束节点 秒级时间戳
     */
    private Date startTimeEndNode;

    /**
     * 结束时间筛选开始节点 秒级时间戳
     */
    private Date endTimeStartNode;

    /**
     * 结束时间筛选结束节点 秒级时间戳
     */
    private Date endTimeEndNode;

    /**
     * userId
     */
    private Long userId;

    /**
     * openId
     */
    private String openId;

    /**
     * 限制数量
     */
    private Integer limitedQuantity;

    /**
     * 仅展示用户参与0否 1是
     */
    private Integer onlyShowUserEngagement;

    /**
     * 时间排序顺序 1开始时间升序 2开始时间倒序
     * 3结束时间升序 4结束时间倒序
     */
    private Integer timeSortOrder;
}
