package cn.com.duiba.zhongyan.activity.service.api.enums;

import cn.hutool.core.bean.BeanException;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

@Getter
@AllArgsConstructor
public enum TravelDescEnums {




    CITY_1(1,"浙江"),

    CITY_2(2,"上海"),

    CITY_3(3,"山东"),

    CITY_4(4,"天津"),

    CITY_5(5,"黑龙江"),

    CITY_6(6,"内蒙古"),

    CITY_7(7,"北京"),

    CITY_8(8,"陕西"),

    CITY_9(9,"甘肃"),

    CITY_10(10,"青海"),

    CITY_11(11,"新疆"),

    CITY_12(12,"西藏"),

    CITY_13(13,"四川"),

    CITY_14(14,"云南"),

    CITY_15(15,"海南"),

    CITY_16(16,"广西"),

    CITY_17(17,"重庆"),

    CITY_18(18,"湖北"),

    CITY_19(19,"湖南"),

    CITY_20(20,"江西"),

    CITY_21(21,"福建");



    private Integer days;

    private String desc;



    public static String getDesc(Integer days){

      return   Arrays.stream(TravelDescEnums.values()).filter( i-> Objects.equals(days,i.getDays())).findFirst().orElseThrow(
                ()->new BeanException("参数异常")
        ).getDesc();
    }

}
