package cn.com.duiba.zhongyan.activity.service.api.remoteservice.statistics;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;

/**
 * @author duib
 * 都是根据 activity 和 type 区分 可通用 走redis
 * type 枚举 自定义
 */
public interface TravelStatisticsConfig {

    /**
     * 每日Uv 用户锁
     */

    String USER_UV_ACTIVITY_LOCK_BY_ACTIVITY_TYPE_DATE = "UV_day_lock_%s_%s_%s_%s";

    /**
     * 获取每日用户锁
     *
     * @return
     */
    static String getUserUvLockByEveryDate(Long activityId, Integer type, Date day, Long userId) {
        return String.format(USER_UV_ACTIVITY_LOCK_BY_ACTIVITY_TYPE_DATE, activityId, type, DateUtils.getDayNumber(day), userId);
    }


    /**
     * 永久UV用户锁
     */

    String USER_UV_ACTIVITY_LOCK_BY_ACTIVITY_TYPE = "UV_lock_%s_%s_%s";

    /**
     * 获取永久用户UV锁
     *
     * @return
     */
    static String getUserUvLockByEveryDate(Long activityId, Integer type, Long userId) {
        return String.format(USER_UV_ACTIVITY_LOCK_BY_ACTIVITY_TYPE, activityId, type, userId);
    }

    /**
     * 每日UV总数
     */
    String USER_UV_COUNT_BY_ACTIVITY_TYPE_DATE = "UV_day_count_%s_%s_%s";

    /**
     * 获取每日UV总数
     *
     * @param activityId
     * @param type
     * @param day
     * @return
     */
    static String getUserUvCountByActivityTypeDate(Long activityId, Integer type, Date day) {
        return String.format(USER_UV_COUNT_BY_ACTIVITY_TYPE_DATE, activityId, type, DateUtils.getDayNumber(day));
    }


    /**
     * 活动期间UV总数
     */
    String USER_UV_COUNT_BY_ACTIVITY_TYPE = "UV_day_count_%s_%s";

    /**
     * 获取活动期间UV 总数
     *
     * @param activityId
     * @param type
     * @return
     */
    static String getUserUvActivityLockByActivityType(Long activityId, Integer type) {
        return String.format(USER_UV_COUNT_BY_ACTIVITY_TYPE, activityId, type);
    }


    /**
     * 每日PV总数
     */
    String USER_PV_COUNT_BY_ACTIVITY_TYPE_DATE = "PV_day_count_%s_%s_%s";

    /**
     * 获取每日UV总数
     *
     * @param activityId
     * @param type
     * @param day
     * @return
     */
    static String getUserPvCountByActivityTypeDate(Long activityId, Integer type, Date day) {
        return String.format(USER_PV_COUNT_BY_ACTIVITY_TYPE_DATE, activityId, type, DateUtils.getDayNumber(day));
    }


    /**
     * 活动期间PV总数
     */
    String USER_PV_COUNT_BY_ACTIVITY_TYPE = "PV_day_count_%s_%s";

    /**
     * 获取活动期间UV 总数
     *
     * @param activityId
     * @param type
     * @return
     */
    static String getUserPvActivityLockByActivityType(Long activityId, Integer type) {
        return String.format(USER_PV_COUNT_BY_ACTIVITY_TYPE, activityId, type);
    }




}
