package cn.com.duiba.zhongyan.activity.service.api.remoteservice.saleuser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.DistinguishDataTrendDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.DistinguishDataViewDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.DistinguishFeedbackCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.DistinguishMsgDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteDistinguishDataTrendParam;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteDistinguishFeedbackParam;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteDistinguishPageParam;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/5/12
 */
@AdvancedFeignClient
public interface RemoteDistinguishSaleCertificateService {

    /**
     * 填反馈
     * @param param
     * @return
     */
    Boolean feedback(RemoteDistinguishFeedbackParam param);

    /**
     * 统计反馈
     * @return
     */
    List<DistinguishFeedbackCountDTO> countFeedback();

    /**
     * 获取近期数据概览
     * @return
     */
    DistinguishDataViewDTO getDataView();

    /**
     * 获取数据趋势
     * @param param
     * @return
     */
    List<DistinguishDataTrendDTO> getDataTrend(RemoteDistinguishDataTrendParam param);


    /**
     * ai识别信息统计
     * @param param
     * @return
     */
    PageResponse<DistinguishMsgDTO> getList(RemoteDistinguishPageParam param);

}
