package cn.com.duiba.zhongyan.activity.service.api.remoteservice.travel;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivitySignDetailRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.travel.IndexTagDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.travel.TravelVoteInfoDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.travel.VoteTravelDto;
import cn.com.duiba.zhongyan.activity.service.api.param.travel.RemoteSubmitTravelParam;

import java.util.Date;
import java.util.List;

/**
 * @author duiba
 */
@AdvancedFeignClient
public interface RemoteTravelService {


    VoteTravelDto voteIndex(Long activityId, Long userId) throws BizException;


    TravelVoteInfoDto getTravelVoteInfo(Long activityId, Long id, Long userId) throws BizException;


    Long submitTravelVote(RemoteSubmitTravelParam remoteSubmitTravelParam) throws BizException;

    /**
     * 根据活动ID和用户ID查询签到记录
     *
     * @param activityId
     * @param userId
     * @return
     */
    List<ActivitySignDetailRecordDTO> listByActivityIdAndUserId(Long activityId, Long userId);

    IndexTagDto getTravelTagVoteInfo(Long activityId, Long userId, String cityCode) throws BizException;

    /**
     * 统计某天参与uv
     * @param activityId
     * @param day
     * @return
     */
    Long countJoinUvDay(Long activityId, String day);

    /**
     * 统计某些天都参与uv
     * @param activityId
     * @param days
     * @return
     */
    Long countJoinUvMixDay(Long activityId, List<String> days);

    /**
     * 统计连续签到uv
     * @param activityId
     * @param now
     * @param offset 连续天数
     * @return
     */
    Long countContinueSignUv(Long activityId, Date now, Integer offset);

    /**
     * 统计累计签到uv
     * @param activityId
     * @param start
     * @param end
     * @param offset 累计天数
     * @return
     */
    Long countLastSignUv(Long activityId, Date start, Date end, Integer offset);


}
