package cn.com.duiba.zhongyan.activity.service.api.domain.dto;

import cn.com.duiba.zhongyan.activity.service.api.enums.ApplicableScenariosEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xuanyu
 * @description: 活动基本配置
 * @date 2021/12/6 9:52 上午
 */
@Data
public class BaseConfigDTO implements Serializable {
    private static final long serialVersionUID = -7291579461934602750L;

    /**
     * 活动题目
     */
    private String activityTitle;

    /**
     * 活动开始时间
     */
    private Long activityStartTime;

    /**
     * 活动结束时间
     */
    private Long activityEndTime;

    /**
     * 活动规则
     */
    private String rule;

    /**
     * 单独投放或嵌入
     * @see ApplicableScenariosEnum
     */
    private Integer applicableScenarios;
}
