package cn.com.duiba.zhongyan.activity.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivitySnapshotDto;
import cn.com.duiba.zhongyan.activity.service.api.param.ActivitySnapshotPageParam;

/**
 * Created by hong
 * time 2022/7/7.
 */
@AdvancedFeignClient
public interface RemoteActivitySnapshotService {
    /**
     * 插入一条记录
     *
     * @param entity 实体对象
     */
    void insert(ActivitySnapshotDto entity);

    /**
     * 根据 ID 查询
     *
     * @param id 主键ID
     */
    ActivitySnapshotDto selectById(Long id);

    /**
     * 根据 entity 条件，查询全部记录（并翻页）
     *
     */
    PageResponse<ActivitySnapshotDto> selectPage(ActivitySnapshotPageParam param);

    /**
     * 根据 ID 删除
     *
     * @param id 主键ID
     */
    int deleteById(Long id);
}
