package cn.com.duiba.zhongyan.activity.service.api.utils;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.zhongyan.activity.service.api.enums.ErrorCodeEnum;
import lombok.extern.slf4j.Slf4j;

/**
 * @author xuanyu
 * @description: 断言
 * @date 2021/11/26 2:10 下午
 */
@Slf4j
public class Conditions {

    public static void expectFalse(boolean expression, String errorMessage) throws BizException {
        if (expression) {
            throw new BizException(errorMessage);
        }
    }


    public static void expectTrue(boolean expression, String errorMessage) throws BizException {
        if (!expression) {
            throw new BizException( errorMessage);
        }
    }

    public static void expectTrue(boolean expression, ErrorCodeEnum errorCodeEnum) throws BizException {
        if (!expression) {
            throw new BizException( errorCodeEnum.errorMessage()).withCode(String.valueOf(errorCodeEnum.errorCode()));
        }
    }

    public static void expectFalse(boolean expression, ErrorCodeEnum errorCodeEnum) throws BizException {
        if (expression) {
            throw new BizException( errorCodeEnum.errorMessage()).withCode(String.valueOf(errorCodeEnum.errorCode()));
        }
    }
}

