package cn.com.duiba.zhongyan.activity.service.api.remoteservice.standard;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @Description 标准化活动签到
 * @Date 2022/11/28 20:06
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemoteStandardSignActivityService {

    /**
     * 获取某段用户的签到时间集合
     * @param activityId
     * @param userId
     * @param startTime
     * @param endTime
     * @return 签到时间集合 yyyy-MM-dd
     */
    List<String> getSignUserTimeList(Long activityId, Long userId, Date startTime, Date endTime);

    /**
     * 签到
     * @param activityId
     * @param userId
     * @return 累计签到天数
     * @throws BizException
     */
    Long doSign(Long activityId, Long userId) throws BizException;
}
