package cn.com.duiba.zhongyan.activity.service.api.param.exclusive;

import cn.com.duiba.zhongyan.activity.service.api.enums.CommonStateEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.utils.validate.EnumValid;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 专属答题活动参数
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/6
 */
@Data
public class ExclusiveQuestionActivityParam implements Serializable {

    private static final long serialVersionUID = 5065884735823381999L;
    /**
     * 活动标题
     */
    @NotBlank(message = "活动标题不能为空")
    @Size(max = 20, message = "活动标题不能超过20个字符")
    private String activityTitle;

    /**
     * 活动时间 index0->开始时间 index1->结束时间
     */
    private List<Date> activityTime;

    /**
     * 活动场景 0-单独投放 1-嵌入其他活动
     */
    @NotNull(message = "活动场景不能为空")
    @EnumValid(target = CommonStateEnum.class, field = "state", message = "活动场景值不合法")
    private Integer activityScenes;

    /**
     * 身份限制 0-不限制 1-限制零售户
     */
    @EnumValid(target = CommonStateEnum.class, field = "state", message = "身份限制值不合法")
    private Integer identityLimit;

    /**
     * 地域限制配置
     */
    @Valid
    private ExclusiveQuestionRegionConfig regionConfig;

    /**
     * 标签列表
     */
    private List<JSONObject> tagConfig;

    /**
     * 用户群id
     */
    private JSONObject customerGroupConfig;

    /**
     * 题目列表
     */
    @NotEmpty(message = "题目列表不能为空")
    @Size(max = 10, message = "最多可以配置10个题目")
    private List<QuestionAnswerParam> questionList;

    /**
     * 个人信息问题列表
     */
    private List<Long> consumerInfoList;

    /**
     * 页面名称
     */
    @NotBlank(message = "页面名称不能为空")
    @Size(max = 12, message = "页面名称不能超过12个字符")
    private String pageTitle;

    /**
     * 缩略图
     */
    @NotBlank(message = "缩略图不能为空")
    private String bannerImg;

    /**
     * 答题背景
     */
    @NotBlank(message = "答题背景不能为空")
    private String answerBackgroundImage;

    /**
     * 题目背景色
     */
    @NotBlank(message = "题目背景色不能为空")
    private String questionBackgroundColor;

    /**
     * 题目文案颜色
     */
    @NotBlank(message = "题目文案颜色不能为空")
    private String questionWordColor;

    /**
     * 选项文案颜色
     */
    @NotBlank(message = "选项文案颜色不能为空")
    private String optionWordColor;

    /**
     * 选中按钮颜色
     */
    @NotBlank(message = "选中按钮颜色不能为空")
    private String chooseButtonColor;

    /**
     * 选项边框颜色
     */
    @NotBlank(message = "选项边框颜色不能为空")
    private String optionFrameColor;

    /**
     * 提交按钮背景
     */
    @NotBlank(message = "提交按钮背景不能为空")
    private String submitButtonImage;

    /**
     * 提交文案颜色
     */
    @NotBlank(message = "提交文案颜色不能为空")
    private String submitWordColor;

    /**
     * 提交成功弹窗
     */
    @NotBlank(message = "提交成功弹窗不能为空")
    private String postSuccessIcon;

    /**
     * 标题
     */
    @NotBlank(message = "请输入标题")
    @Size(max = 25, message = "标题不能超过25个字符")
    private String shareTitle;
    /**
     * 副标题
     */
    @NotBlank(message = "请输入副标题")
    @Size(max = 50, message = "副标题不能超过50个字符")
    private String shareSubtitle;
    /**
     * 分享图标
     */
    @NotBlank(message = "分享图标不能为空")
    private String shareBackgroundImage;

    /**
     * 是否是复制的活动
     * true-复制活动  false/null-非复制活动
     */
    private Boolean isCopy;
    /**
     * true-预览并保存  false/null-发布
     */
    private Boolean isPreview;

}
