package cn.com.duiba.zhongyan.activity.service.api.param.export;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/5/17
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RemoteSaleDistinguishRecordExportRecordRequest extends RemoteExportRecordRequest{

    private static final long serialVersionUID = -7077963657815887262L;
    /**
     * 图片上传开始时间
     */
    private Date uploadStartTime;

    /**
     * 图片上传结束时间
     */
    private Date uploadEndTime;

    /**
     * 专卖证号
     */
    private String certificateNo;

    /**
     * 零售户手机号
     */
    private String salePhone;

    /**
     * 反馈人名称
     */
    private String feedbackName;

    /**
     * 反馈原因 1、 图片比较清晰可以识别 2、  照片角度正常但识别结果显示角度不正常
     *   3、识别到的专卖证号和照片中的不一致 4、 图片是许可证，但识别结果显示不是许可证 5、  图片比较清晰可以识别
     */
    private Integer feedback;
}
