package cn.com.duiba.zhongyan.activity.service.api.domain.dto.display;

import cn.com.duiba.zhongyan.activity.service.api.enums.DisplayCheckStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 陈列阶段审核表
 * @Date 2022/8/1 14:54
 * @Author LuHui
 */
@Data
public class DisplayCheckRecordDto implements Serializable {
    private static final long serialVersionUID = -5291335778438271464L;

    /**
     * id
     */
    private Long id;


    /**
     * 活动id
     */

    private Long activityId;

    /**
     * 阶段id
     */
    private Long stageId;


    /**
     * 用户id
     */

    private Long userId;

    /**
     * 星光值
     */
    private Long score;

    /**
     * 状态 0:未确认, 1已确认, 2审核中，3已审核
     * @see DisplayCheckStatusEnum
     */
    private Integer status;

    /**
     * 陈列识别结果
     */
    private String result;

    /**
     * 陈列图片地址
     */
    private String imageUrl;

    /**
     * 反馈原因
     */
    private String reason;

    /**
     * 审核结果
     */
    private String verifyResult;

    /**
     * 创建日期
     */

    private Date gmtCreate;

    /**
     * 修改日期
     */

    private Date gmtModified;

    /**
     * 市
     */
    private String city;

    /**
     * 审核时间
     */
    private Date verifyTime;

    /**
     * 审核人
     */
    private Long verifyUser;

}
