package cn.com.duiba.zhongyan.activity.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * @author zht
 * @Date 2022/8/2
 */

@AllArgsConstructor
@Getter
public enum ActivityVoteTypeEnum {


    VISIT_PV_TYPE(1, "访问pv"),
    VISIT_UV_TYPE(2, "访问uv"),
    JOIN_ENTER_UV_TYPE(3, "报名Uv"),
    JOIN_VOTE_UV_TYPE(4, "参与投票Uv");


    private Integer type;

    private String desc;


    public ActivityVoteTypeEnum getActivityVoteEnum(Integer type) {
        return Stream.of(ActivityVoteTypeEnum.values()).filter(i -> Objects.equals(i.getType(), type))
                .findFirst().orElseThrow(() -> new RuntimeException("参数错误"));
    }


}
