/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.enums.QuestionTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.utils.question.AbstractQuestionAnswerCheckHandler;
import cn.com.duiba.zhongyan.activity.service.api.utils.question.AnswerCheckContext;
import cn.hutool.extra.emoji.EmojiUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class MonthChoiceHandler
extends AbstractQuestionAnswerCheckHandler {
    private static final SimpleDateFormat MONTH = new SimpleDateFormat("yyyy-MM");

    @Override
    public QuestionTypeEnum getType() {
        return QuestionTypeEnum.MONTH_CHOICE;
    }

    @Override
    void specificQuestionCheck(QuestionAnswerParam param) throws BizException {
        Conditions.expectTrue((StringUtils.isBlank((CharSequence)param.getQuestionTip()) || EmojiUtil.removeAllEmojis((String)param.getQuestionTip()).length() <= 20 ? 1 : 0) != 0, (String)("\u9898\u76ee[" + param.getQuestionId() + "]:\u9898\u76ee\u63d0\u793a\u8bed\u9519\u8bef-\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26"));
    }

    @Override
    String specificAnswerCheck(QuestionAnswerParam param, AnswerCheckContext context) throws BizException {
        Integer questionId = param.getQuestionId();
        Conditions.expectTrue((param.getAnswerList().size() == 1 ? 1 : 0) != 0, (String)("\u9898\u76ee[" + questionId + "]:\u7b54\u6848\u9519\u8bef-\u6708\u4efd\u9898\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u7b54\u6848"));
        AnswerParam answer = param.getAnswerList().get(0);
        Conditions.expectTrue((boolean)StringUtils.isNotBlank((CharSequence)answer.getAnswer()), (String)("\u9898\u76ee[" + questionId + "]:\u7b54\u6848\u9519\u8bef-\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a"));
        Conditions.expectNotNull((Object)MonthChoiceHandler.getMonth(answer.getAnswer()), (String)("\u9898\u76ee[" + questionId + "]:\u7b54\u6848\u9519\u8bef-\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e"));
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date getMonth(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = MONTH;
        synchronized (simpleDateFormat) {
            try {
                return MONTH.parse(dateStr);
            }
            catch (ParseException e) {
                return null;
            }
        }
    }
}

