/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.enums.CommonStateEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.utils.question.AbstractQuestionAnswerCheckHandler;
import cn.com.duiba.zhongyan.activity.service.api.utils.question.AnswerCheckContext;
import cn.hutool.core.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class QuestionUtil {
    private static Map<Integer, AbstractQuestionAnswerCheckHandler> handlerMap;

    public static AbstractQuestionAnswerCheckHandler getHandler(Integer type) throws BizException {
        Conditions.expectNotNull((Object)type, (String)"\u9898\u76ee\u7c7b\u578b\u9519\u8bef-\u4e0d\u80fd\u4e3a\u7a7a");
        AbstractQuestionAnswerCheckHandler handler = handlerMap.get(type);
        Conditions.expectNotNull((Object)handler, (String)("\u4e0d\u652f\u6301\u7684\u9898\u76ee\u7c7b\u578b:" + type));
        return handler;
    }

    public static void checkQuestion(List<QuestionAnswerParam> questionList) throws BizException {
        List<Integer> allQuestionIds = QuestionUtil.getAllQuestionIds(questionList);
        ArrayList<Integer> beforeQuestionIds = new ArrayList<Integer>();
        for (QuestionAnswerParam param : questionList) {
            QuestionUtil.getHandler(param.getType()).checkQuestion(param, allQuestionIds, beforeQuestionIds);
            beforeQuestionIds.add(param.getQuestionId());
        }
    }

    public static String checkAnswer(List<QuestionAnswerParam> questionList) throws BizException {
        StringBuilder answerStr = new StringBuilder();
        AnswerCheckContext context = new AnswerCheckContext();
        AtomicInteger questionNo = new AtomicInteger(0);
        for (QuestionAnswerParam param : questionList) {
            context.setQuestionNo(questionNo.incrementAndGet());
            answerStr.append(QuestionUtil.getHandler(param.getType()).checkAnswer(param, context));
        }
        return answerStr.toString();
    }

    private static List<Integer> getAllQuestionIds(List<QuestionAnswerParam> questionList) throws BizException {
        Conditions.expectTrue((boolean)CollectionUtils.isNotEmpty(questionList), (String)"\u95ee\u9898\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        List<Integer> allQuestionIds = questionList.stream().filter(q -> Objects.isNull(q.getSource()) || CommonStateEnum.STATE_ZERO.getState().equals(q.getSource())).map(QuestionAnswerParam::getQuestionId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Conditions.expectTrue((questionList.size() == allQuestionIds.size() ? 1 : 0) != 0, (String)"\u9898\u76eeid\u9519\u8bef-\u4e3a\u7a7a\u6216\u5b58\u5728\u91cd\u590did");
        return allQuestionIds;
    }

    static {
        List handlerClassList;
        Class<AbstractQuestionAnswerCheckHandler> fatherClass = AbstractQuestionAnswerCheckHandler.class;
        String pkgName = ClassUtil.getPackage(fatherClass);
        Set classes = ClassUtil.scanPackage((String)pkgName);
        if (CollectionUtils.isEmpty((Collection)classes)) {
            handlerMap = Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(handlerClassList = classes.stream().filter(sonClass -> ClassUtil.isAssignable((Class)fatherClass, (Class)sonClass) && fatherClass != sonClass).collect(Collectors.toList()))) {
            handlerMap = Collections.emptyMap();
        }
        handlerMap = handlerClassList.stream().map(clazz -> {
            try {
                return (AbstractQuestionAnswerCheckHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(o -> o.getType().getQuestionType(), Function.identity()));
    }
}

