package cn.com.duiba.zhongyan.activity.service.api.param;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class AddActivityUserAddressParam implements Serializable {
    private static final long serialVersionUID = 1055228745889474952L;

    @NotNull(message = "活动id不能为空")
    private Long activityId;

    @NotNull(message = "用户id不能为空")
    private Long userId;

    @NotBlank(message = "省份不能为空")
    private String province;

    @NotBlank(message = "城市不能为空")
    private String city;

    @NotBlank(message = "行政区不能为空")
    private String area;

    private String street = StringUtils.EMPTY;

    @NotBlank(message = "省编码不能为空")
    private String provinceCode;

    @NotBlank(message = "市编码不能为空")
    private String cityCode;

    @NotBlank(message = "地区编码不能为空")
    private String areaCode;

    private String streetCode = StringUtils.EMPTY;

    @NotBlank(message = "详细地址不能为空")
    @Length(min = 1, max = 200)
    private String addressDetail;

    @NotBlank(message = "完整地址的MD5值不能为空")
    private String fullAddressMd5;

    @NotBlank(message = "邮编不能为空")
    private String postcode;

    @NotBlank(message = "收件人手机号不能为空")
    private String receiverPhone;

    @NotBlank(message = "收件人姓名不能为空")
    private String receiverName;
}
