package cn.com.duiba.zhongyan.activity.service.api.param;

import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityUserRecordDTO;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author linzhou
 * @ClassName SaveActivityUserRecordParam.java
 * @createTime 2022年02月09日 15:13:00
 * @Description
 */
@Getter
@Setter
public class SaveActivityUserRecordParam implements Serializable{

    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * open_id,新增时必填
     */
    private String openId;
    /**
     * 活动名称,新增时必填
     */
    private String activityTitle;
    /**
     * 必填
     * 活动Id
     */
    private String activityId;
    /**
     * 活动类型,允许多个["01","02"]
     */
    private String activityType;
    /**
     * 参与时间,新增时必填
     */
    private Date joinTime;
    /**
     * 新增时必填
     * 是否中奖 0:未中奖 1:已中奖新增时必填
     */
    private Integer acquirePrize;
    /**
     * 必填
     * 数据来源:0:自有数据 1:老兑吧数据 2:周力
     */
    private Integer dataSourceType;

    /**
     * 扩展信息
     */
    private ActivityUserRecordDTO.Extra extra;
    /**
     * 活动图片地址
     */
    private String imageUrl;

//    private String orderNo;

    private Date startTime;
    /**
     * 活动开始时间
     */
    private Date endTime;
    /**
     * 活动结束时间
     */
    private Integer prizeStatus;
    /**
     * 必填
     * 来源数据id,来源方活动参与记录id
     */
    private String dataSourceId;

    @Getter
    @Setter
    public static class Extra implements Serializable {
        private List<ActivityUserRecordDTO.Order> order;
    }

    @Getter
    @Setter
    public static class Order implements Serializable {
        /**
         * 订单号,非必填
         */
        private String orderNo;
        /**
         * 物流单号,非必填
         */
        private String logisticsNo;
        /**
         * 物流公司名称,非必填
         */
        private String logisticsName;
        /**
         * 商品详情,非必填
         */
        private List<ActivityUserRecordDTO.Product> product;
    }

    @Getter
    @Setter
    public static class Product implements Serializable {
        /**
         * 商品图片地址
         */
        private String image;
        /**
         * 商品名称
         */
        private String name;
    }
}
