package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityUserRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.ActivityUserRecordListParam;
import cn.com.duiba.zhongyan.activity.service.api.param.SaveActivityUserRecordParam;

import java.util.List;

/**
 * @author linzhou
 * @ClassName RemoteActivityUserRecordService.java
 * @createTime 2022年01月24日 10:31:00
 * @Description
 */
@AdvancedFeignClient
public interface RemoteActivityUserRecordService {


    /**
     * 查询用户中奖纪录表
     *
     * @param param
     * @return
     */
    PageResponse<ActivityUserRecordDTO> getActivityUserRecordList(ActivityUserRecordListParam param);


    /**
     * 保存参与记录接口,不区分新增和保存,根据activityId dataSourceType dataSourceId的唯一判断是新增或者保存
     * 必须保证activityId dataSourceType dataSourceId三个字段唯一,三个字段必填
     *
     * @param record 参与记录
     * @return
     * @throws BizException
     */
    Long saveActivityUserRecord(SaveActivityUserRecordParam record) throws BizException;

    void batchSaveActivityUserRecord(List<SaveActivityUserRecordParam> recordParamList) throws BizException;
}
