package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.QuestionAreaAnswerDto;
import cn.com.duiba.zhongyan.activity.service.api.enums.QuestionTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

/**
 * @Description 地区下拉选择题校验处理
 * @Date 2023/6/21 15:17
 * @Author LuHui
 */
public class AreaChoiceHandle extends AbstractQuestionAnswerCheckHandler{

    @Override
    public QuestionTypeEnum getType() {
        return QuestionTypeEnum.AREA_CHOICE;
    }

    @Override
    void specificQuestionCheck(QuestionAnswerParam param) throws BizException {
    }

    @Override
    String specificAnswerCheck(QuestionAnswerParam param, AnswerCheckContext context) throws BizException {
        Integer questionId = param.getQuestionId();
        Conditions.expectTrue(param.getAnswerList().size() == 1, "题目["+ questionId +"]:答案错误-地区选择题只能存在一个答案");
        AnswerParam answer = param.getAnswerList().get(0);
        // 校验地区
        Conditions.expectTrue(StringUtils.isNotBlank(answer.getAnswer()), "题目["+ questionId +"]:答案错误-地区选择不能为空");
        QuestionAreaAnswerDto questionAreaAnswerDto = JSONObject.parseObject(answer.getAnswer(), QuestionAreaAnswerDto.class);
        Conditions.expectFalse(StringUtils.isAnyBlank(questionAreaAnswerDto.getProvinceCode(), questionAreaAnswerDto.getProvinceName(), questionAreaAnswerDto.getCityCode(), questionAreaAnswerDto.getCityName()), "题目["+ questionId +"]:答案错误-地区选择不能为空");
        // todo 时间关系 后期按地区编码校验所填地区是否正确
        // 没什么要校验的
        return EMPTY_STRING;
    }
}
