package cn.com.duiba.cloud.manage.service.api.model.dto.sso;

import cn.com.duiba.cloud.manage.service.api.model.enums.sso.UserTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

/**
 * 登录凭证
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SsoTicket implements Serializable {

    /**
     * 登录人
     */
    private Long adminId;

    /**
     * 登录过期时间 未来某个时间戳
     */
    private Long expiredTime;

    /**
     * 当前登录用户类型
     */
    private UserTypeEnum userTypeEnum;

    /**
     * 有效时长 单位s
     */
    private int effectiveDuration;

    /**
     * 计算用户登录过期时间
     */
    public void computeExpiredTime() {

        if (UserTypeEnum.B.equals(userTypeEnum)) {
            //b端用户24小时过期
            effectiveDuration = 24 * 60 * 60 + 5;
        } else {
            effectiveDuration = 2 * 60 * 60 + 5;
        }
        //获取未来过期时间戳
        LocalDateTime localDateTime = LocalDateTime.now().plusSeconds(effectiveDuration);
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        expiredTime = zonedDateTime.toInstant().toEpochMilli();
    }
}
