package cn.com.duiba.cloud.manage.service.api.model.param.user;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;


/**
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RegisterUserParam implements Serializable {

    private static final long serialVersionUID = 1814124741562222990L;

    @NotBlank(message = "员工编号不能为空")
    private String userId;

    /**
     * 手机号号段可能会新增所以不能太严格
     * "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(18[0,5-9]))\\d{8}$"
     */
    @Pattern(regexp = "\\d{11}",message = "手机号格式不正确")
    private String phone;

    @Pattern(regexp = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,16}$",message = "密码格式不正确")
    private String password;

    @NotNull(message = "名称不能为空")
    private String name;
}
