package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.hutool.core.util.StrUtil;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description redis key
 * @date 2021/11/8 11:20
 */
public enum RedisKeyEnum {

    /**
     * 企业相关
     */
    FIRST_LOGIN("首次登录", "DUIBA_MANAGE_SERVICE:FIRST_LOGIN"),
    CAPTCHA("图片验证码", "DUIBA_MANAGE_SERVICE:CAPTCHA"),
    LAST_LOGIN("上次登录", "DUIBA_MANAGE_SERVICE:LAST_LOGIN"),
    TENANT_STAFF_REL("企业内员工关系", "DUIBA_MANAGE_SERVICE:TENANT_STAFF_REL:{}_{}"),

    /* 角色相关 */

    UNIQUE_TENANT_ROLE_NAME("企业下角色名称唯一", "DUIBA_MANAGE_SERVICE:TB_ROLE:{}_{}"),
    UNIQUE_TENANT_NAME("企业名称唯一", "DUIBA_MANAGE_SERVICE:TB_TENANT:{}"),

    ;

    private final String desc;
    private final String template;

    RedisKeyEnum(String desc, String template) {
        this.desc = desc;
        this.template = template;
    }

    public static String getRedisKey(RedisKeyEnum keyTemplate, Object... args) {
        return StrUtil.format(keyTemplate.template, args);
    }
}
