package cn.com.duiba.cloud.manage.service.api.model.dto.report;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 平和味道报表
 *
 * @author xuanhongjian
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@SuppressWarnings("all")
public class PhwdDTO implements Serializable {

    /**
     * 日期
     */
    private Data date;

    /**
     * 平和味道公众号关注粉丝量-合计
     */
    private Long followFansUV;

    /**
     * 平和味道公众号关注粉丝量-省内
     */
    private Long followFansInsideUV;

    /**
     * 平和味道公众号关注粉丝量-省外
     */
    private Long followFansOutsideUV;

    /**
     * 平和味道粉丝注册量
     */
    private Long registerFansTotalUV;

    /**
     * 新增入网量-合计
     */
    private Long approvalCntUV;

    /**
     * 新增入网量-省内
     */
    private Long approvalInsideUV;

    /**
     * 新增入网量-省外
     */
    private Long approvalOutsideUV;

    /**
     * 累计入网量-合计
     */
    private Long accumulateApprovalCntUV;

    /**
     * 累计入网量-省内
     */
    private Long accumulateApprovalInsideUV;

    /**
     * 累计入网量-省外
     */
    private Long accumulateApprovalOutsideUV;

    /**
     * 新增入网量剔除已获知取关量-合计
     */
    private Long eliminateIncreApprovalCntUV;

    /**
     * 新增入网量剔除已获知取关量-省内
     */
    private Long eliminateIncreApprovalInsideUV;

    /**
     * 新增入网量剔除已获知取关量-省外
     */
    private Long eliminateIncreApprovalOutsideUV;

    /**
     * 累计入网量剔除已获知取关量-合计
     */
    private Long eliminateAccumulateApprovalCntUV;

    /**
     * 累计入网量剔除已获知取关量-省内
     */
    private Long eliminateAccumulateApprovalInsideUV;

    /***
     * '累计入网量剔除已获知取关量-省外'
     */
    private Long eliminateAccumulateApprovalOutsideUV;

    /**
     * '零售户活动交互（活动交互）'
     */
    private Long retailerActivityParticipationPV;

    /**
     * '消费者活动交互（活动交互）'
     */
    private Long consumerActivityParticipationPV;

    /**
     * '推文阅读量（宣传交互）'
     */
    private Long tweetReadingPV;
}
