package cn.com.duiba.cloud.manage.service.api.remoteservice.report;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.ActivityReplayDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.PhwdDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.RetailerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.TagDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.TobaccoReportDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.WechatFansDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.WechatPageReadDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.report.ActivityReplayParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.DeleteActivityParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.ReportParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.SaveActivityParam;
import cn.com.duiba.cloud.manage.service.api.model.param.report.UpdateActivityReplayParam;
import cn.com.duiba.cloud.manage.service.api.utils.UploadResult;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author xuanhongjian
 */
@AdvancedFeignClient
@SuppressWarnings("all")
public interface RemoteReportService {

    /**
     * 平和味道报表
     *
     * @param param 参数
     * @return 分页数据
     */
    PageResponse<PhwdDTO> queryPhwd(ReportParam param);

    /**
     * 零售户入网2021.5.31版
     *
     * @param param 参数
     * @return 分页数据
     */
    PageResponse<RetailerDTO> queryRetailer(ReportParam param);

    /**
     * 公众号粉丝变化
     *
     * @param param
     * @return
     */
    PageResponse<WechatFansDTO> queryWechatFans(ReportParam param);

    /**
     * 公众号阅读量
     *
     * @param param
     * @return
     */
    // xhj-todo 0  号添加总计
    PageResponse<WechatPageReadDTO> queryWechatPageRead(ReportParam param);

    /**
     * 卷烟扫码量
     *
     * @param param
     * @return
     */
    PageResponse<TobaccoReportDTO> queryTobacco(ReportParam param);


    /**
     * 标签统计
     *
     * @param param
     * @return
     */
    PageResponse<TagDTO> queryTag(ReportParam param);

    /**
     * 活动复盘
     *
     * @param param 参数
     * @return
     */
    PageResponse<ActivityReplayDTO> queryActivityReplay(ActivityReplayParam param);

    /**
     * 保存运营复牌
     *
     * @param param 参数
     * @return id
     */
    Long saveActivityReplay(SaveActivityParam param);

    /**
     * 删除运营复牌
     *
     * @param param 参数
     * @return boolean
     */
    Boolean deleteActivityReplay(DeleteActivityParam param);

    /**
     * 更新运营复牌
     *
     * @param param 参数
     * @return boolean
     */
    Boolean updateActivityReplay(UpdateActivityReplayParam param);

    /**
     * 导出没有运营复盘
     *
     * @param reportParam
     * @return
     */
    UploadResult exportReportWithOutReplay(ReportParam reportParam);

    /**
     * 导出有运营复盘
     *
     * @param activityReplayParam
     * @return
     */
    UploadResult exportReport(ActivityReplayParam activityReplayParam);


}
