package cn.com.duiba.cloud.manage.service.api.model.enums.report;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;

/**
 * 香烟种类
 * @author xuanhongjian
 */
public enum TobaccoTypeEnum {
    /**
     * 登录信息验证
     */

    FIRST("first", "利群(休闲细支)",1),
    SECOND("second", "利群(休闲细支试制)",2),
    THIRD("third", "利群(天外天)",3),
    FOUR("four", "利群(楼外楼)",4),
    FIVE("five", "利群(江南韵)",5),
    SIX("six", "利群(试制)",6),
    SEVEN("seven", "利群(阳光橙中支)",7),
    EIGHT("eight", "利群(阳光橙中支)新品",8);
    private static final ImmutableMap<String, TobaccoTypeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<String, TobaccoTypeEnum> builder = ImmutableMap.builder();
        for (TobaccoTypeEnum item : TobaccoTypeEnum.values()) {
            builder = builder.put(item.type, item);
        }
        INNER_MAP = builder.build();
    }


    /**
     * 种类
     */
    private final String type;
    /**
     * 名字
     */
    private final String name;

    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public Integer getSort() {
        return sort;
    }

    /**
     * sort
     */
    private final Integer sort;

    TobaccoTypeEnum(String type, String name, Integer sort) {
        this.type = type;
        this.name = name;
        this.sort = sort;
    }

    @SuppressWarnings("unused")
    public static TobaccoTypeEnum getByCode(String type) {
        return Objects.isNull(type) ? null : INNER_MAP.get(type);
    }


}
