package cn.com.duiba.cloud.manage.service.api.model.param.sso;

import cn.com.duiba.cloud.manage.service.api.annotation.DataSecretFiledAnnotation;
import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * 找回密码
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RetrievePasswordParam {

    /**
     * 新密码
     */
    @Pattern(regexp = RegexpConst.PASSWORD, message = "新密码格式不正确")
    @DataSecretFiledAnnotation
    private String newPassword;

    /**
     * 短信唯一key
     */
    @NotNull(message = "短信唯一id不能为空")
    private String smsKey;
}
