package cn.com.duiba.cloud.manage.service.api.remoteservice.redis;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.redis.RedisReturnDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.redis.RemoteMultiGetParam;
import cn.com.duiba.cloud.manage.service.api.model.param.redis.RemoteZsetRemoveParam;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * @author yuanzhixin
 */
@AdvancedFeignClient
public interface RemoteRedisService {

    /**
     * 删除
     * @param key
     * @return
     */
    Boolean delete(String key);

    /**
     * 获取
     * @param key
     * @return
     */
    String get(String key);

    /**
     * 自增
     * @param key
     * @param delta
     */
    void increment(String key, Long delta);


    /**
     * 过期
     * @param key
     * @param timeOut
     * @param timeUnit 单位
     */
    void expire(String key, Long timeOut, TimeUnit timeUnit);


    /**
     * 设置值
     * @param key
     * @param value
     * @param timeOut
     * @param timeUnit 单位
     * @return
     */
    Boolean setIfAbsent(String key, String value, Long timeOut, TimeUnit timeUnit);

    /**
     * 设置值
     * @param key
     * @param value
     * @param timeOut
     * @param timeUnit 单位
     * @return
     */
    void set(String key, String value, Long timeOut, TimeUnit timeUnit);

    /**
     *
     * @param param
     * @return
     */
    Long zsetRemove(RemoteZsetRemoveParam param);

    /**
     *
     * @param key
     * @param values
     * @return
     */
    Long zsetAdd(String key, String... values);

    /**
     *
     * @param key
     * @return
     */
    Set<String> members(String key);

    /**
     *
     * @param param
     * @return
     */
    List<String> multiGet(RemoteMultiGetParam param);

    /**
     * 获取过期时间
     * @param key
     * @return
     */
    Long getExpire(String key);

    /**
     * hash get
     * @param key
     * @param hashKey
     * @return
     */
    RedisReturnDTO hGet(String key, String hashKey);

    /**
     * hash put
     * @param key
     * @param hashKey
     * @param value
     */
    void hPut(String key, String hashKey, String value);

    /**
     * hash delete
     * @param key
     * @param hashKey
     * @return
     */
    Long hDel(String key, String hashKey);

}
