package cn.com.duiba.cloud.manage.service.api.model.enums.exportrecord;

import java.util.Objects;

/**
 * @author linzhou
 * @ClassName ImportDataTypeEnum.java
 * @createTime 2021年11月03日 19:40:00
 * @Description
 */
public enum ExportDataTypeEnum {
    STAFF_INVITE(1,"员工导出"),
    ROLE_STAFF_INVITE(2,"角色员工导出"),
    ORDER_EXPORT(3, "订单导出"),
    EMS_DELIVER_GOODS_EXPORT(4, "ems发货列表导出"),
    DATA_REPORT_EXPORT(5,"数据报表导出"),
    TEMPLATE_PUSH_RECORD(6,"模版消息推送导出"),
    STATISTICS_PAGE_EXPORT(7,"统计页面数据导出"),
    STATISTICS_UNIT_EXPORT(8,"统计组件数据导出"),
    ACTIVITY_POINT(9,"活动积分详情导出"),
    ACTIVITY_USER_POINT_RECORD(10,"活动个人积分记录"),
    ACTIVITY_USER_PRIZE(11,"活动个人获奖记录"),
    ;

    /**
     *
     */
    private Integer type;
    /**
     * 描述
     */
    private String desc;

    ExportDataTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ExportDataTypeEnum getExportDataTypeEnum(Integer type){
        for (ExportDataTypeEnum value : ExportDataTypeEnum.values()) {
            if (Objects.equals(value.getType(),type)){
                return value;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
