package cn.com.duiba.cloud.manage.service.api.model.dto.ocr;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * 功能描述：烟草专卖证识别
 *
 * @Auther: xiaotian
 * @Date: 2022/3/1 14:41
 * @Description:
 */

@Data
public class LicenceOcrDto implements Serializable {
    private static final long serialVersionUID = 1583832446288176439L;

    /**
     * [int32]0表示成功
     */
    @JSONField(name = "err_code")
    private Integer errCode;
    /**
     * 错误描述
     */
    @JSONField(name = "err_desc")
    private String errDesc;
    /**
     * 识别出来的数据
     */
    @JSONField(name = "info")
    private OcrDto info;

    /**
     * 是否成功
     * @return
     */
    public boolean success(){
        return Integer.valueOf(0).equals(this.getErrCode());
    }

    @Data
    public static class OcrDto implements Serializable{
        private static final long serialVersionUID = 7484326211050758265L;
        /**
         * [string]许可证类型
         */
        @JSONField(name = "licence_type")
        private String licenceType;
        /**
         * [string]许可证号
         */
        @JSONField(name = "licence_number")
        private String licenceNumber;
        /**
         * [number]许可证号置信度0-100，阈值95
         */
        @JSONField(name = "licence_number_confidence")
        private Long licenceNumberConfidence;
        /**
         * [string]国家局编码
         */
        @JSONField(name = "national_office_code")
        private String nationalOfficeCode;
        /**
         * /[number]国家局编码置信度0-100，阈值95
         */
        @JSONField(name = "national_office_code_confidence")
        private Long nationalOfficeCodeConfidence;
        /**
         * [string]企业名称
         */
        @JSONField(name = "company_name")
        private String companyName;
        /**
         * [string]企业类型
         */
        @JSONField(name = "company_type")
        private String companyType;
        /**
         * [string]负责人姓名
         */
        @JSONField(name = "person_name")
        private String personName;
        /**
         * [string]有效期限开始
         */
        @JSONField(name = "effective_date_start")
        private String effectiveDateStart;
        /**
         * [string]有效期限结束
         */
        @JSONField(name = "effective_date_end")
        private String effectiveDateEnd;
        /**
         * [string]供货单位
         */
        @JSONField(name = "supplier")
        private String supplier;
    }

}
