package cn.com.duiba.cloud.manage.service.api.model.enums.audit;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @program: duiba-manage-service
 * @description: 审核状态 0-待审核 1-审核通过 2-审核拒绝
 * @author: 郭云龙
 * @create: 2021-11-08 10:53
 **/

@Getter
@AllArgsConstructor
public enum AuditStateEnum implements IEnum<String> {

    /**
     * REVIEW("0","审核中"),
     * PASS("1","审核通过"),
     * REFUSE("2","审核拒绝");
     */
    REVIEW("0", "审核中"),
    PASS("1", "审核通过"),
    REFUSE("2", "审核拒绝");

    private final String key;
    private final String value;

    @Override
    public String getDbCode() {
        return key;
    }
}
