/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.enums.report;

import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.CityDTO;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public enum RegionDivideEnum {
    NORTH_CHINA("\u534e\u5317", Lists.newArrayList((Object[])new CityDTO[]{CityDTO.builder().cityName("\u5317\u4eac\u5e02").code("110000").build(), CityDTO.builder().cityName("\u5929\u6d25\u5e02").code("120000").build(), CityDTO.builder().cityName("\u6cb3\u5317\u7701").code("130000").build()})),
    NORTHEAST("\u4e1c\u5317", Lists.newArrayList((Object[])new CityDTO[]{CityDTO.builder().cityName("\u8fbd\u5b81\u7701").code("210000").build(), CityDTO.builder().cityName("\u5409\u6797\u7701").code("220000").build(), CityDTO.builder().cityName("\u9ed1\u9f99\u6c5f\u7701").code("230000").build()})),
    EAST_CHINA("\u534e\u4e1c", Lists.newArrayList((Object[])new CityDTO[]{CityDTO.builder().cityName("\u4e0a\u6d77\u5e02").code("310000").build(), CityDTO.builder().cityName("\u6c5f\u82cf\u7701").code("320000").build(), CityDTO.builder().cityName("\u5b89\u5fbd\u7701").code("340000").build(), CityDTO.builder().cityName("\u5c71\u4e1c\u7701").code("370000").build()})),
    SOUTH_CHINA("\u534e\u5357", Lists.newArrayList((Object[])new CityDTO[]{CityDTO.builder().cityName("\u5e7f\u4e1c\u7701").code("440000").build(), CityDTO.builder().cityName("\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a").code("450000").build(), CityDTO.builder().cityName("\u6d77\u5357\u7701").code("460000").build()})),
    CENTRAL_SOUTH("\u4e2d\u5357", Lists.newArrayList((Object[])new CityDTO[]{CityDTO.builder().cityName("\u798f\u5efa\u7701").code("350000").build(), CityDTO.builder().cityName("\u6e56\u5357\u7701").code("430000").build(), CityDTO.builder().cityName("\u6c5f\u897f\u7701").code("360000").build(), CityDTO.builder().cityName("\u6e56\u5317\u7701").code("420000").build()})),
    NORTHWEST("\u897f\u5317", Lists.newArrayList((Object[])new CityDTO[]{CityDTO.builder().cityName("\u5185\u8499\u53e4\u81ea\u6cbb\u533a").code("150000").build(), CityDTO.builder().cityName("\u7518\u8083\u7701").code("620000").build(), CityDTO.builder().cityName("\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a").code("650000").build(), CityDTO.builder().cityName("\u9752\u6d77\u7701").code("630000").build(), CityDTO.builder().cityName("\u5b81\u590f").code("640000").build()})),
    SOUTHWEST("\u897f\u5357", Lists.newArrayList((Object[])new CityDTO[]{CityDTO.builder().cityName("\u4e91\u5357\u7701").code("530000").build(), CityDTO.builder().cityName("\u8d35\u5dde\u7701").code("520000").build(), CityDTO.builder().cityName("\u56db\u5ddd\u7701").code("510000").build(), CityDTO.builder().cityName("\u91cd\u5e86\u5e02").code("500000").build()})),
    CENTRAL_PLAIN("\u4e2d\u539f", Lists.newArrayList((Object[])new CityDTO[]{CityDTO.builder().cityName("\u9655\u897f\u7701").code("610000").build(), CityDTO.builder().cityName("\u6cb3\u5357\u7701").code("410000").build(), CityDTO.builder().cityName("\u5c71\u897f\u7701").code("140000").build()}));

    private static final ImmutableMap<String, RegionDivideEnum> INNER_MAP;
    private final String regionName;
    private final List<CityDTO> provinceName;

    private RegionDivideEnum(String regionName, List<CityDTO> provinceName) {
        this.regionName = regionName;
        this.provinceName = provinceName;
    }

    public static RegionDivideEnum getByCode(String regionName) {
        return Objects.isNull(regionName) ? null : (RegionDivideEnum)((Object)INNER_MAP.get((Object)regionName));
    }

    public static RegionDivideEnum getByProvinceName(String provinceName) {
        for (Map.Entry entry : INNER_MAP.entrySet()) {
            RegionDivideEnum v = (RegionDivideEnum)((Object)entry.getValue());
            List<CityDTO> provinceNames = v.getProvinceName();
            boolean b = provinceNames.stream().anyMatch(province -> province.getCityName().contains(provinceName));
            if (!b) continue;
            return v;
        }
        return null;
    }

    public static CityDTO getProvinceByProvinceName(String provinceName) {
        if (StrUtil.isBlank((CharSequence)provinceName)) {
            return null;
        }
        for (Map.Entry entry : INNER_MAP.entrySet()) {
            RegionDivideEnum v = (RegionDivideEnum)((Object)entry.getValue());
            List cityList = v.getProvinceName().stream().filter(province -> province.getCityName().contains(provinceName)).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(cityList)) continue;
            return (CityDTO)cityList.get(0);
        }
        return new CityDTO();
    }

    public static List<RegionDivideEnum> getList() {
        return INNER_MAP.values().asList();
    }

    public String getRegionName() {
        return this.regionName;
    }

    public List<CityDTO> getProvinceName() {
        return this.provinceName;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RegionDivideEnum item : RegionDivideEnum.values()) {
            builder = builder.put((Object)item.getRegionName(), (Object)item);
        }
        INNER_MAP = builder.build();
    }
}

