package cn.com.duiba.cloud.manage.service.api.model.enums.terminal;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 17:13
 */
@Getter
@AllArgsConstructor
public enum RetailerStateEnum implements IEnum<Integer> {

    /**
     *
     */
    WAIT_INVITE(1, "待接收"),
    WAIT_CONFIRM_SHIP(2, "待确认发货"),
    WAIT_RECEIPT(3, "待收货"),
    GETTING(4, "获客中"),
    THREE_DAY_NONE(5, "3日无获客"),
    WAIT_AWARD(6, "待领奖"),
    AWARDED(7, "已领奖"),
    NOT_ELIGIBLE(8, "无领奖资格")
    ;

    private final Integer code;
    private final String desc;

    @Override
    public Integer getDbCode() {
        return code;
    }
}
