package cn.com.duiba.cloud.manage.service.api.remoteservice.terminal;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.RetailerExecPageDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.TerminalStaffExecPageDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteRetailerExecPageParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalStaffExecPageParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
* @author yuanzhixin
* @version 1.0
* @date 2022-05-26 10:38:19
*/
@AdvancedFeignClient
public interface RemoteRetailerProgressService {

    /**
     * 执行管理-终端业务员管理分页查询
     * @param param 查询参数
     * @return 分页结果
     * @throws BizException 查询异常
     */
    PageResponse<TerminalStaffExecPageDTO> terminalPage(RemoteTerminalStaffExecPageParam param) throws BizException;

    /**
     * 执行管理-零售户分页查询
     * @param param 查询参数
     * @return 分页结果
     */
    PageResponse<RetailerExecPageDTO> retailerPage(RemoteRetailerExecPageParam param);
}
