package cn.com.duiba.cloud.manage.service.api.remoteservice.terminal;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.TerminalDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.TerminalStaffPageDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalEditParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalEnableDisableParam;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.RemoteTerminalStaffPageParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
* @author yuanzhixin
* @version 1.0
* @date 2022-05-26 10:38:06
*/
@AdvancedFeignClient
public interface RemoteTerminalStaffService {

    /**
     * 分页查询
     * @param param 查询参数
     * @return 分页结果
     * @throws BizException 查询异常
     */
    PageResponse<TerminalStaffPageDTO> page(RemoteTerminalStaffPageParam param) throws BizException;

    /**
     * 启用、停用
     * @param param 请求参数
     * @throws BizException 操作异常
     */
    void enableOrDisable(RemoteTerminalEnableDisableParam param) throws BizException;

    /**
     * 详情
     * @param param 查询参数
     * @return 详情
     * @throws BizException 查询异常
     */
    TerminalDetailDTO detail(RemoteTerminalDetailParam param) throws BizException;

    /**
     * 编辑保存
     * @param param 请求参数
     * @throws BizException 操作异常
     */
    void edit(RemoteTerminalEditParam param) throws BizException;

    /**
     * 添加终端业务员
     * @param param 请求参数
     * @return id
     * @throws BizException 操作异常
     * @throws InterruptedException 加锁异常
     */
    Long add(RemoteTerminalAddParam param) throws BizException, InterruptedException;
}
