package cn.com.duiba.cloud.manage.service.api.model.dto.supplier;

import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.DeliGoodsRecommendEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.DeliGoodsStateEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 商品信息
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/1/28
 */
@Getter
@Setter
public class DeliGoodsInfoDTO implements Serializable {

    private static final long serialVersionUID = -9205460457227846640L;

    /**
     * 商品唯一编码 sku
     */
    private String sku;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 条形码
     */
    private String upc;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 单价（含税）（结算价）
     */
    private Double price;

    /**
     * 市场价（含税）
     */
    private Double marketPrice;

    /**
     * 建议销售价
     */
    private Double suggestPrice;

    /**
     * 税率，保留小数点两位：例如 17%的税率， 传递 0.17
     */
    private Double taxRate;

    /**
     * 税收分类编码
     */
    private Integer taxId;

    /**
     * 税收分类名称
     */
    private String taxName;

    /**
     * 税额
     */
    private Double taxPrice;

    /**
     * 净价
     */
    private Double nakedPrice;

    /**
     * 最小购买数量
     */
    private Integer minBuyNum;

    /**
     * 包装清单
     */
    private String wareqd;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 是否推荐 0：不推荐，1 推荐
     * @see DeliGoodsRecommendEnum
     */
    private Integer recommend;

    /**
     * 上下架状态 1：上架 0：下架
     * @see DeliGoodsStateEnum
     */
    private Integer state;

    /**
     * 商品目录编码
     */
    private String catalogCode;

    /**
     * 商品目录名称
     */
    private String catalogName;

    /**
     * 品牌英文名称
     */
    private String brandEn;

    /**
     * 品牌中文名称
     */
    private String brandCn;

    /**
     * 商品主图，单张图片，以 HTTP 开头的绝 对路径
     */
    private String primaryImg;

    /**
     * 多张图片以逗号隔开，以 HTTP 开头的绝 对路径
     */
    private String otherImg;

    /**
     * 商品详细描述
     */
    private String details;

    /**
     * 商品规格
     */
    private String specs;

    /**
     * 商品库存
     */
    private Integer stock;

    /**
     * 产地
     */
    private String productArea;

    /**
     * 型号
     */
    private String model;

    /**
     * 品牌编码
     */
    private String brandId;

    /**
     * 商品商城url
     */
    private String url;

    /**
     * 是否节能
     */
    private String isEnergy;

    /**
     * 是否环保
     */
    private String isProtection;

    /**
     * 规格，格式：内存:4G;硬盘:1T;
     */
    private String briefConfig;

}
