package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.SupplierCodeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 地址匹配参数
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/17
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteAddressMappingParam implements Serializable {

    private static final long serialVersionUID = 6190147126533357618L;
    /**
     * 供应商
     * @see SupplierCodeEnum
     */
    @NotBlank(message = "供应商code不能为空")
    private String supplierCode;

    /**
     * 一级地址名称
     */
    @NotBlank(message = "一级地址不能为空")
    private String firstName;

    /**
     * 二级地址名称
     */
    @NotBlank(message = "二级地址不能为空")
    private String secondName;

    /**
     * 三级地址名称
     */
    @NotBlank(message = "三级地址不能为空")
    private String thirdName;


}
