package cn.com.duiba.cloud.manage.service.api.remoteservice.cheatCenter;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.cheatCenter.BlackWhiteDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.cheatCenter.BlackWhiteListDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.cheatCenter.CheatCountDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.cheatCenter.CheatListAllCountDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.cheatCenter.CheatLogDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.cheatCenter.RemoteCheatCountParam;
import cn.com.duiba.cloud.manage.service.api.model.param.cheatCenter.RemoteCheatListExchangeParam;
import cn.com.duiba.cloud.manage.service.api.model.param.cheatCenter.RemoteCheatListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.cheatCenter.RemoteCheatListRemoveParam;
import cn.com.duiba.cloud.manage.service.api.model.param.cheatCenter.RemoteCheatLogParam;
import cn.com.duiba.cloud.manage.service.api.model.param.cheatCenter.RemoteCheatSelectParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author xiaotian
 * @description: 防作弊中心
 * @date 2022/06/10 6:07 下午
 */
@AdvancedFeignClient
public interface RemoteCheatCenterService {

    /**
     * 名单分页筛选
     *
     * @param remoteCheatListParam
     * @return
     */
    PageResponse<BlackWhiteListDTO> queryList(RemoteCheatListParam remoteCheatListParam);

    /**
     * 撞库明细分页筛选
     *
     * @param remoteCheatLogParam
     * @return
     */
    PageResponse<CheatLogDTO> queryCheatLogList(RemoteCheatLogParam remoteCheatLogParam);

    /**
     * 批量新增名单
     *
     * @param blackWhiteListDTOList
     * @return
     */
    int batchSaveCheatList(List<BlackWhiteListDTO> blackWhiteListDTOList);

    /**
     * 批量新增撞库明细
     *
     * @param cheatLogDTOS
     * @return
     */
    int batchSaveCheatLog(List<CheatLogDTO> cheatLogDTOS);

    /**
     * 移除
     *
     * @param remoteCheatListRemoveParam
     * @return
     */
    boolean removeCheatList(RemoteCheatListRemoveParam remoteCheatListRemoveParam);

    /**
     * 移入
     *
     * @param remoteCheatListExchangeParam
     * @return
     */
    int exchange(RemoteCheatListExchangeParam remoteCheatListExchangeParam);

    /**
     * 获取用户撞库量
     *
     * @param remoteCheatCountParam
     * @return
     */
    CheatCountDTO getCheatCount(RemoteCheatCountParam remoteCheatCountParam);

    /**
     * 获取黑灰名单的总数量
     *
     * @return
     */
    CheatListAllCountDTO getAllCheatListCount();


    /**
     * 查询客户黑灰名单
     * @param remoteCheatSelectParams
     * @return
     */
    List<BlackWhiteDetailDTO> getPersonBlackGrey(RemoteCheatSelectParam remoteCheatSelectParams);

}
