package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import cn.com.duiba.cloud.manage.service.api.model.param.PageBaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 15:36
 */
@Getter
@Setter
public class RemoteRetailerExecPageParam extends PageBaseParam {

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;

    /**
     * 终端业务员id
     */
    private Long terminalId;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 零售户姓名
     */
    private String cName;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 专卖证号
     */
    private String saleCertificateNo;

    /**
     * 关注状态, 0 未关注，1 已关注
     */
    private Integer subscribeStatus;

    /**
     * 地区code
     */
    private List<String> addressCode;

    /**
     * 终端业务员姓名
     */
    private String name;

    /**
     * 终端业务员手机号
     */
    private String phone;
}
