package cn.com.duiba.cloud.manage.service.api.model.param.terminal;


import cn.com.duiba.cloud.manage.service.api.annotation.EnumValid;
import cn.com.duiba.cloud.manage.service.api.model.enums.EnableStateEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 14:00
 */
@Getter
@Setter
public class RemoteTerminalEnableDisableParam extends BaseParam {

    /**
     * id
     */
    @NotNull(message = "id 不能为空")
    private Long id;

    /**
     * 状态
     */
    @NotNull(message = "启用、禁用状态不能为空")
    @EnumValid(target = EnableStateEnum.class, message = "启用、禁用状态不合法")
    private Integer state;
}
