package cn.com.duiba.cloud.manage.service.api.model.dto.terminal;

import lombok.*;

import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/6/29 11:41
 **/
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class DataDetailDTO implements Serializable {

    /**
     * 时间
     */
    private String date;

    /**
     * 领取成功人数
     */
    private Long userNum;

    /**
     * 领取成功人次
     */
    private Long num;

    /**
     * 活动未开始人数
     */
    private Long beforeBeginUserNum;

    /**
     * 活动未开始人次
     */
    private Long beforeBeginNum;

    /**
     * 活动已结束人数
     */
    private Long endUserNum;

    /**
     * 活动已结束人次
     */
    private Long endNum;

    /**
     * 二维码未生效人数
     */
    private Long qrcodeUserNum;

    /**
     * 二维码未生效人次
     */
    private Long qrcodeNum;

    /**
     * 库存不足人数
     */
    private Long stockUserNum;

    /**
     * 库存不足人次
     */
    private Long stockNum;

    /**
     * 店铺活动结束人数
     */
    private Long shopEndUserNum;

    /**
     * 店铺活动结束人次
     */
    private Long shopEndNum;

    /**
     * 非新客人数
     */
    private Long notNewUserNum;

    /**
     * 非新客人次
     */
    private Long notNewNum;

    /**
     * 未到间隔时间人数
     */
    private Long notGapUserNum;

    /**
     * 未到间隔时间人次
     */
    private Long notGapNum;

    /**
     * 达到限制次数人数
     */
    private Long limitUserNum;

    /**
     * 达到限制次数人次
     */
    private Long limitNum;

    /**
     * 重复领取人数
     */
    private Long repeatUserNum;

    /**
     * 重复领取人次
     */
    private Long repeatNum;

    /**
     * 黑名单人数
     */
    private Long blackUserNum;

    /**
     * 黑名单人次
     */
    private Long blackNum;

    public DataDetailDTO buildEmptyDTO(String date) {
        return DataDetailDTO.builder()
                .date(date)
                .userNum(0L)
                .num(0L)
                .beforeBeginUserNum(0L)
                .beforeBeginNum(0L)
                .endUserNum(0L)
                .endNum(0L)
                .qrcodeUserNum(0L)
                .qrcodeNum(0L)
                .stockUserNum(0L)
                .stockNum(0L)
                .shopEndUserNum(0L)
                .shopEndNum(0L)
                .notNewUserNum(0L)
                .notNewNum(0L)
                .notGapUserNum(0L)
                .notGapNum(0L)
                .limitUserNum(0L)
                .limitNum(0L)
                .repeatUserNum(0L)
                .repeatNum(0L)
                .blackUserNum(0L)
                .blackNum(0L)
                .build();
    }
}
