/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.handler;

import cn.com.duiba.cloud.manage.service.api.annotation.DataMaskingAnnotation;
import cn.com.duiba.cloud.manage.service.api.annotation.DataMaskingFiledAnnotation;
import cn.hutool.core.util.DesensitizedUtil;
import java.util.Objects;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class DataMaskingHandler
implements ResponseBodyAdvice<Object> {
    public static final String DATA_MASKING_ANNOTATION = "DATA_MASKING_ANNOTATION";

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = sra.getRequest();
        DataMaskingAnnotation dataMaskingAnnotation = (DataMaskingAnnotation)request.getAttribute(DATA_MASKING_ANNOTATION);
        return dataMaskingAnnotation != null;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (Objects.isNull(body)) {
            return body;
        }
        Stream.of(body.getClass().getDeclaredFields()).forEach(field -> {
            if (field.isAnnotationPresent(DataMaskingFiledAnnotation.class)) {
                DesensitizedUtil.DesensitizedType desensitizedType = field.getAnnotation(DataMaskingFiledAnnotation.class).value();
                try {
                    field.setAccessible(true);
                    field.set(body, DesensitizedUtil.desensitized((CharSequence)String.valueOf(field.get(body)), (DesensitizedUtil.DesensitizedType)desensitizedType));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
        return body;
    }
}

