package cn.com.duiba.cloud.manage.service.api.remoteservice.consumerinfo;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.consumerinfo.ConsumerInfoConfigDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo.RemoteConsumerInfoConfigChangeSortParam;
import cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo.RemoteConsumerInfoConfigEditInfoContentParam;
import cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo.RemoteConsumerInfoConfigEditInfoTypeParam;
import cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo.RemoteConsumerInfoConfigPageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.consumerinfo.RemoteConsumerInfoConfigSaveParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 远程个人信息配置服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/7
 */
@AdvancedFeignClient
public interface RemoteConsumerInfoConfigService {

    /**
     * 信息配置分页查询
     *
     * @param remoteParam 入参
     * @return 分页列表
     * @throws BizException
     */
    PageResponse<ConsumerInfoConfigDTO> pageQuery(RemoteConsumerInfoConfigPageQueryParam remoteParam) throws BizException;

    /**
     * 保存信息配置
     *
     * @param remoteParam 入参
     * @return id
     * @throws BizException
     */
    Long save(RemoteConsumerInfoConfigSaveParam remoteParam) throws BizException;

    /**
     * 修改信息名称
     *
     * @param remoteParam 入参
     * @return 是否成功
     * @throws BizException
     */
    Boolean editInfoType(RemoteConsumerInfoConfigEditInfoTypeParam remoteParam) throws BizException;

    /**
     * 修改信息题目
     *
     * @param remoteParam 入参
     * @return 是否成功
     * @throws BizException
     */
    Boolean editInfoContent(RemoteConsumerInfoConfigEditInfoContentParam remoteParam) throws BizException;

    /**
     * 信息配置详情
     *
     * @param id id
     * @return 详细信息
     * @throws BizException
     */
    ConsumerInfoConfigDTO detail(Long id) throws BizException;

    /**
     * 删除信息配置
     *
     * @param id id
     * @return 是否成功
     * @throws BizException
     */
    Boolean delete(Long id) throws BizException;

    /**
     * 修改顺序
     *
     * @param remoteParam 入参
     * @return 是否成功
     * @throws BizException
     */
    Boolean changeSort(RemoteConsumerInfoConfigChangeSortParam remoteParam) throws BizException;

    /**
     * 通过id查询
     * @param ids
     * @return
     * @throws BizException
     */
    List<ConsumerInfoConfigDTO> queryByIds(List<Long> ids) throws BizException;

}