package cn.com.duiba.cloud.manage.service.api.remoteservice.role;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.role.RoleDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.role.RoleDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.role.RoleListDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.role.StaffAuthDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.role.RemoteRoleDeleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.role.RemoteRoleDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.role.RemoteRoleListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.role.RemoteRoleQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.role.RemoteRoleSaveParam;
import cn.com.duiba.cloud.manage.service.api.model.param.role.RemoteRoleUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.role.RemoteStaffAuthParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
* 角色信息 RemoteService
* @author jiangyesheng
* 2021-11-3 16:13:33
*/
@AdvancedFeignClient
public interface RemoteRoleService {

    /**
     * 分页查询角色列表
     * @param queryParam 查询参数
     * @return
     * @throws BizException
     */
    public PageResponse<RoleDTO> roleQuery(RemoteRoleQueryParam queryParam) throws BizException;

    /**
     * 查询角色详细信息
     * @param detailParam 详情参数
     * @return
     * @throws BizException
     */
    public RoleDetailDTO roleDetail(RemoteRoleDetailParam detailParam) throws BizException;

    /**
     * 批量删除角色
     * @param deleteParam 删除参数
     * @throws BizException
     */
    public void roleDelete(RemoteRoleDeleteParam deleteParam) throws BizException;

    /**
     * 添加角色
     * @param saveParam 角色添加
     * @return 主键id
     * @throws BizException
     */
    public Long roleSave(RemoteRoleSaveParam saveParam) throws BizException;

    /**
     * 更新角色信息
     * @param updateParam 更新参数
     * @throws BizException
     */
    public void updateById(RemoteRoleUpdateParam updateParam) throws BizException;

    /**
     * 获取员工的总权限
     * @param remoteStaffAuthParam
     * @return
     * @throws Exception
     */
    public StaffAuthDTO staffAuth(RemoteStaffAuthParam remoteStaffAuthParam) throws BizException;

    /**
     * 查询企业的角色列表
     * @param listParam
     * @return
     * @throws BizException
     */
    public RoleListDTO roleList(RemoteRoleListParam listParam) throws BizException;

}
