package cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("all")
public class ProvinceRetailerDTO extends BusinessDTO {

    private static final long serialVersionUID = 2106660744346967509L;
    /**
     * 省份下市区数据
     */
    List<CityRetailerDTO> cityRetailerList;
    /**
     * 省份
     */
    private String provinceName;
    /**
     * 省份编码
     */
    private String code;

    public void setTargetProgress(BigDecimal targetProgress) {
        this.targetProgress = targetProgress;
        if (targetProgress != null) {
            targetProgressStr = targetProgress.toPlainString();
        }
    }

    public void summary() {
        List<CityRetailerDTO> cityRetailerList = this.cityRetailerList;
        if (CollectionUtils.isEmpty(cityRetailerList)) {
            return;
        }
        //累加计算省份数据
        cityRetailerList.forEach(cityRetailerDTO -> {
            userCount = add(cityRetailerDTO.getUserCount(), userCount);
            userCountNotFollowing = add(cityRetailerDTO.getUserCountNotFollowing(), userCountNotFollowing);
            userIncreaseCountNotFollowing = add(cityRetailerDTO.getUserIncreaseCountNotFollowing(), userIncreaseCountNotFollowing);
            inviteAccumulativeCount = add(cityRetailerDTO.getInviteAccumulativeCount(), inviteAccumulativeCount);
            inviteSingleMonthCount = add(cityRetailerDTO.getInviteSingleMonthCount(), inviteSingleMonthCount);
            phwdAccumulativeCount = add(cityRetailerDTO.getPhwdAccumulativeCount(), phwdAccumulativeCount);
            phwdSingleMonthCount = add(phwdSingleMonthCount, cityRetailerDTO.getPhwdSingleMonthCount());
            selfDisciplineAccumulativeCount = add(selfDisciplineAccumulativeCount, cityRetailerDTO.getSelfDisciplineAccumulativeCount());
            selfDisciplineSingleMonthCount = add(selfDisciplineSingleMonthCount, cityRetailerDTO.getSelfDisciplineSingleMonthCount());
            leagueAccumulativeCount = add(leagueAccumulativeCount, cityRetailerDTO.getLeagueAccumulativeCount());
            leagueSingleMonthCount = add(leagueSingleMonthCount, cityRetailerDTO.getLeagueSingleMonthCount());
            getCustomersAccumulativeCount = add(getCustomersAccumulativeCount, cityRetailerDTO.getGetCustomersAccumulativeCount());
            getCustomersSingleMonthCount = add(getCustomersSingleMonthCount, cityRetailerDTO.getGetCustomersSingleMonthCount());
            scanCodeAccumulativeCount = add(scanCodeAccumulativeCount, cityRetailerDTO.getScanCodeAccumulativeCount());
            scanCodeSingleMonthCount = add(scanCodeSingleMonthCount, cityRetailerDTO.getScanCodeSingleMonthCount());
            othersAccumulativeCount = add(othersAccumulativeCount, cityRetailerDTO.getOthersAccumulativeCount());
            othersSingleMonthCount = add(othersSingleMonthCount, cityRetailerDTO.getOthersSingleMonthCount());
        });
    }

    public void calculateSchedule() {
        this.setTargetProgress(calculateSchedule(new BigDecimal(userIncreaseCountNotFollowing == null ? 0L : userIncreaseCountNotFollowing),
                new BigDecimal(userIncreaseCountNotFollowingTarget == null ? 0L : userIncreaseCountNotFollowingTarget)));
        cityRetailerList.forEach(cityRetailerDTO -> {
            BigDecimal actualValue = new BigDecimal(
                    cityRetailerDTO.getUserIncreaseCountNotFollowing() == null ?
                            0 : cityRetailerDTO.getUserIncreaseCountNotFollowing());
            BigDecimal targetValue = new BigDecimal(
                    cityRetailerDTO.getUserIncreaseCountNotFollowingTarget() == null ?
                            0 : cityRetailerDTO.getUserIncreaseCountNotFollowingTarget());
            BigDecimal bigDecimal = calculateSchedule(actualValue, targetValue);
            cityRetailerDTO.setTargetProgress(bigDecimal);
        });
    }

    private BigDecimal calculateSchedule(BigDecimal actualValue, BigDecimal targetValue) {
        BigDecimal progress = new BigDecimal(0L).setScale(2, BigDecimal.ROUND_HALF_UP);
        // 合计新增户数（剔除取关）÷当年目标新增户数（剔除取关）
        boolean actualFlag = actualValue == null
                || actualValue.compareTo(new BigDecimal(0)) == 0;
        boolean targetFlag = targetValue == null
                || targetValue.compareTo(new BigDecimal(0)) == 0;
        if (targetFlag || actualFlag) {
            return progress;
        } else {
            // 合计新增户数 * 100 / 当年目标新增户数  四舍五入取两位小数
            progress = actualValue.multiply(new BigDecimal(100))
                    .divide(targetValue, 2, BigDecimal.ROUND_HALF_DOWN)
                    .setScale(2, BigDecimal.ROUND_HALF_DOWN);
        }
        return progress;
    }

    private Long add(Long first, Long second) {
        long l = first == null ? 0L : first;
        long l1 = second == null ? 0L : second;
        return l + l1;
    }
}
