package cn.com.duiba.cloud.manage.service.api.model.enums.cheat;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description
 * @Date 2022/7/18 17:55
 * @Author LuHui
 */
public enum CheatOriginEnum {
    DEFAULT(0, "手动"),
    TENCENT(1,"天御"),
    ;

    private Integer code;

    private String desc;

    CheatOriginEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static CheatOriginEnum getCheatOriginEnumByCode(Integer code){
        return Arrays.stream(values())
                .filter(originEnum-> Objects.equals(originEnum.getCode(),code))
                .findFirst()
                .orElse(null);
    }
}
