package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * 特殊票据信息
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/18
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteSuningSpecialVatTicketParam implements Serializable {

    private static final long serialVersionUID = 3179738629519609944L;
    /**
     * 纳税人识别号：数字或字母，字段长度为15、18、20位 （企业开票必填）
     */
    private String taxNo;

    /**
     * 增票注册电话（发票类型为1时必传）
     */
    private String regTel;

    /**
     * 增票银行注册账户（发票类型为1时必传）
     */
    private String regAccount;

    /**
     * 增票注册地址（发票类型为1时必传）
     */
    private String regAdd;

    /**
     * 增票注册公司名称（发票类型为1时必传）
     */
    private String companyName;

    /**
     * 增票注册银行（发票类型为1时必传）
     */
    private String regBank;

    /**
     * 收票件人姓名（发票类型为1或3时必传
     */
    private String consigneeName;

    /**
     * 收票件人地址（发票类型为1或3时必传）
     */
    private String consigneeAddress;

    /**
     * 收票件人电话（发票类型为1或3时必传）
     */
    private String consigneeMobileNum;









}
