package cn.com.duiba.cloud.manage.service.api.model.enums.system;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 异步导出任务状态枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-09-06 13:39
 * @since 0.0.3
 **/
@Getter
@AllArgsConstructor
public enum AsyncExportStatusEnum implements IEnum<Integer> {
    /**
     * 处理中
     */
    PROCESSING(1, "处理中"),

    /**
     * 处理完成
     */
    COMPLETED(2, "处理完成"),

    /**
     * 异常状态
     */
    EXCEPTION(3, "异常状态"),
    ;

    /**
     * 异步导出任务状态值
     */
    private Integer dbCode;

    /**
     * 异步导出任务状态文本
     */
    private String text;
}
